/*
 * @(#)InsertImageCommand.java 5.1
 *
 */
package CH.ifa.draw.figures;

import java.awt.Component;
import java.awt.Image;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.util.Iconkit;

/**
 * Command to insert a named image.
 */
public class InsertImageCommand extends UndoableCommand {
    /**
     * The unused {@code DrawingEditor} of the class to coordinate drawings.
     */
    protected DrawingEditor fEditor;

    /**
     * pathName of the Image.
     */
    private String fImage;

    /**
     * Creates a new InsertImageCommand.
     *
     * @param name the command name
     * @param image the pathname of the image
     */
    public InsertImageCommand(String name, String image) {
        super(name);
        fImage = image;
        // fEditor = editor;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();

        // ugly cast to component, but AWT wants an Component instead of an ImageObserver...
        Image image = Iconkit.instance().registerAndLoadImage((Component) view, fImage);
        ImageFigure figure = new ImageFigure(image, fImage, view.lastClick());
        view.add(figure);
        view.clearSelection();
        view.addToSelection(figure);
        view.checkDamage();
        return true;
    }
}