package CH.ifa.draw.figures;

import java.awt.Point;

import CH.ifa.draw.framework.Figure;

/**
 * Defines methods for manipulating the Points (nodes) of figures,
 * including inserting, removing, setting, and retrieving Points.
 */
public interface PolyLineable extends Figure {

    /**
     * Line shape.
     */
    public final static int LINE_SHAPE = 0;

    /**
     * B-spline shape.
     */
    public final static int BSPLINE_SHAPE = 1;

    /**
     * Inserts a Point/node at the given index.
     *
     * @param p Point to be inserted
     * @param i index
     */
    public abstract void insertPointAt(Point p, int i);

    /**
     * Removes the Point at the given index.
     *
     * @param i index
     */
    public abstract void removePointAt(int i);

    /**
     * Sets the given index to the given Point.
     *
     * @param p Point
     * @param i index
     */
    public abstract void setPointAt(Point p, int i);

    /**
     * Returns the number of Points in the Figure.
     *
     * @return number of Points
     */
    public abstract int pointCount();

    /**
     * Returns the Point found at the given index.
     *
     * @param i index
     * @return Point found at index
     */
    public abstract Point pointAt(int i);
}