/*
 * @(#)DrawingChangeEvent.java 5.1
 *
 */

package CH.ifa.draw.framework;

import java.awt.Rectangle;
import java.util.EventObject;


/**
 * The event passed to DrawingChangeListeners.
 *
 */
public class DrawingChangeEvent extends EventObject {

    /**
     * Represents the area in the drawing that is being modified or tracked.
     */
    private final Rectangle _rectangle;

    /**
     * Constructs a drawing change event.
     * @param source drawing the event comes from
     * @param r rectangle
     * */
    public DrawingChangeEvent(Drawing source, Rectangle r) {
        super(source);
        _rectangle = r;
    }

    /**
     * Gets the changed drawing.
     * @return the changed drawing
     */
    public Drawing getDrawing() {
        return (Drawing) getSource();
    }

    /**
     * Gets the changed rectangle.
     * @return changed rectangle
     */
    public Rectangle getInvalidatedRectangle() {
        return _rectangle;
    }
}