/*
 * @(#)DrawingChangeListener.java 5.1
 *
 */

package CH.ifa.draw.framework;

import java.util.EventListener;


/**
 * Listener interested in Drawing changes.
 */
public interface DrawingChangeListener extends EventListener {

    /**
     * Sent when an area is invalid.
     * @param e event triggered by changes in drawing
     */
    void drawingInvalidated(DrawingChangeEvent e);

    /**
     *  Sent when the drawing wants to be refreshed
     * @param e event triggered by changes in drawing
     */
    void drawingRequestUpdate(DrawingChangeEvent e);
}