package CH.ifa.draw.framework;

/**
 * This interface manages the drawing context of a figure.
 */
public interface DrawingContext {
    /**
     * Method that returns if a figure is highlighted.
     * @param figure the current figure
     * @return whether the figure is highlighted or not
     */
    boolean isHighlighted(Figure figure);

    /**
     * Method that returns if a figure is visible.
     * @param figure the current figure
     * @return whether the figure is visible or not
     */
    boolean isVisible(Figure figure);

    /**
     * Method to expand macros.
     * @param text the macro to be expanded
     * @return the expanded macro
     */
    String expandMacro(String text);
}