package CH.ifa.draw.framework;

/**
 * An interface for figures that support partial selection behavior.
 */
public interface PartialSelectableFigure {
    /**
     * Determines whether the figure can be selected when a
     * modifier key is used.
     * @return boolean. {@code true} if figure can be selected
     */
    boolean isModifierSelectable();

    /**
     * Determines whether the figure is selectable in the specified region.
     * @param x point on x-axis
     * @param y point on y-axis
     * @return boolean, {@code true} if selectable
     */
    boolean isSelectableInRegion(int x, int y);
}