package CH.ifa.draw.framework;

import java.util.Set;
import javax.swing.AbstractButton;


/**
 * A container holding tool buttons whose tools can manipulate the data of a {@link Drawing}.
 */
public interface Toolbar {

    /**
     * The same as {@link #addTools(Set, String, String)}, but the name is also used as the description.
     * @param name description and name of button
     * @param buttons a set of toolbuttons
     */
    void addTools(Set<AbstractButton> buttons, String name);

    /**
     * Add a set of tool buttons to the contained toolbar.
     * @param buttons A set of tool buttons.
     * @param name The name of the tool button set, should be unique.
     * @param description A short description of the tools' purpose.
     */
    void addTools(Set<AbstractButton> buttons, String name, String description);

    /**
     * Remove the set of tool buttons identified by the given String.
     * @param name The name of the tool button set to be removed.
     */
    void removeTools(String name);
}
