package CH.ifa.draw.gui;

import CH.ifa.draw.gui.controller.SettingsController;
import CH.ifa.draw.util.Command;


/**
 * Command to open the settings window.
 */
public class OpenSettingsWindowCommand extends Command {

    /**
     * Creates a new OpenSettingsWindowCommand.
     */
    public OpenSettingsWindowCommand() {
        super("Plugin-Settings");
    }

    @Override
    public void execute() {
        SettingsController settingsController = new SettingsController();
        settingsController.openSettingsWindow();
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void setIsExecutable(boolean executable) {
        super.setIsExecutable(executable);
    }
}
