package CH.ifa.draw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

import de.renew.windowmanagement.DraggableComponentDropTarget;


public class ToolButtonPanel extends JPanel implements DraggableComponentDropTarget, Scrollable {

    @Override
    public void dropComponent(Component draggedComponent, Point locationOnScreen) {

        if (this.isVisible()) {
            Point thisLocation = this.getLocationOnScreen();
            Point adjustedLocation =
                new Point(locationOnScreen.x - thisLocation.x, locationOnScreen.y - thisLocation.y);
            Component target = getComponentAt(adjustedLocation);

            if (draggedComponent instanceof ToolButtonContainer) {

                if (target instanceof ToolButtonContainer) {

                    int index = 0;
                    int count = getComponentCount();

                    for (int i = 0; i < count; i++) {
                        if (getComponent(i) == target) {
                            index = i;
                            break;
                        }
                    }

                    add(draggedComponent, index);
                }
            } else {
                if (target instanceof DraggableComponentDropTarget) {
                    ((DraggableComponentDropTarget) target)
                        .dropComponent(draggedComponent, locationOnScreen);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    /**
     * Removes all registered {@link ToolButtonContainer} instances.
     */
    public void removeAllToolButtonContainers() {
        Component[] components = getComponents();
        for (Component c : components) {
            if (c instanceof ToolButtonContainer) {
                remove(c);
            }
        }
        revalidate();
    }
}
