package CH.ifa.draw.gui.settingswindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import CH.ifa.draw.gui.reactivecomponents.Component;


/**
 * This class represents the side navigation component of the settings window.
 * It is responsible for rendering the side navigation panel which includes a list of plugins.
 * Each plugin in the list is represented by a {@link PluginNavigationComponent}.
 * The side navigation panel is a part of the settings window and is used to navigate between different plugin settings.
 */
public class SideNavComponent extends Component {

    private static final String TITLE = "Plugins";
    private static final int TITLE_FONTSIZE = 13;
    private static final int SIDENAV_WIDTH = 200;
    private static final int TITLE_WRAPPER_HEIGHT = 35;
    private static final EmptyBorder TITLE_WRAPPER_BORDER = new EmptyBorder(10, 10, 10, 10);

    private final Map<String, Runnable> _pluginEntries;

    /**
     * Creates a new SideNavComponent.
     *
     * @param pluginEntries The entries of the plugins to be displayed in the side navigation.
     */
    protected SideNavComponent(Map<String, Runnable> pluginEntries) {
        _pluginEntries = pluginEntries;
    }

    @Override
    protected JComponent render() {
        JComponent sideNav = new JPanel();
        setLayout(sideNav);
        setLabelIn(sideNav);
        renderSideNavItemsIn(sideNav);

        return sideNav;
    }

    private void setLayout(JComponent sideNav) {
        sideNav.setPreferredSize(new Dimension(SIDENAV_WIDTH, Integer.MAX_VALUE));
        sideNav.setMaximumSize(new Dimension(SIDENAV_WIDTH, Integer.MAX_VALUE));
        sideNav.setLayout(new BoxLayout(sideNav, BoxLayout.Y_AXIS));
    }

    private void setLabelIn(JComponent sidenav) {
        JLabel title = new JLabel();
        title.setText(TITLE);
        Font font = title.getFont();
        title.setFont(new Font(font.getName(), font.getStyle(), TITLE_FONTSIZE));

        JPanel titleWrapper = new JPanel();
        titleWrapper.setPreferredSize(new Dimension(Integer.MAX_VALUE, TITLE_WRAPPER_HEIGHT));
        titleWrapper.setMaximumSize(
            new Dimension(Integer.MAX_VALUE, titleWrapper.getPreferredSize().height));
        titleWrapper.setBackground(Color.WHITE);
        titleWrapper.setLayout(new BorderLayout());
        titleWrapper.setBorder(TITLE_WRAPPER_BORDER);

        titleWrapper.add(title, BorderLayout.WEST);

        sidenav.add(titleWrapper);
    }

    private void renderSideNavItemsIn(JComponent parentContainer) {

        Component sideNavItems = new SideNavItemsComponent(_pluginEntries);
        parentContainer.add(sideNavItems.get());
    }
}
