package CH.ifa.draw.io;

/**
 * Extends the CombinationFileFilter to accept the Image file types png, jpg, gif.
 */
public class ImageFileFilter extends CombinationFileFilter {

    /**
     * Constructs ImageFileFilter and adds three filters for png, jpg and gif files.
     */
    public ImageFileFilter() {
        super("Image File (png, jpg, gif)");
        add(new PNGFileFilter());
        add(new JPGFileFilter());
        add(new GIFFileFilter());
    }

    /**
     * Extends CombinationFileFilter to accept jpeg and jpg image files.
     */
    public class JPGFileFilter extends CombinationFileFilter {

        /**
         * Constructs and sets up JPGFileFilter with super class constructor.
         */
        public JPGFileFilter() {
            super("JPEG File Filter");
            add(new SimpleFileFilter("jpg", " Joint Photographic Experts Group File"));
            add(new SimpleFileFilter("jpeg", " Joint Photographic Experts Group File"));
        }
    }
    /**
     * Extends SimpleFileFilter to accept gif image files.
     */
    public class GIFFileFilter extends SimpleFileFilter {
        /**
         * Constructs GIFFileFilter with parent class constructor.
         */
        public GIFFileFilter() {
            super("gif", "Graphics Interchange Format File");
        }
    }
}