package CH.ifa.draw.io.exportFormats;

import CH.ifa.draw.util.Command;

/**
 * Abstract implementation of Command to be executed on ExportFormat.
 */
public abstract class ExportFormatCommand extends Command {
    // Attributes
    // The ImportFormat
    private ExportFormat _format;

    /**
     * Constructs ExportFormatCommand with the ExportFormat to be executed on and an appendix
     * that together with the format name forms the command name.
     *
     * @param format The export format the command is executed on
     * @param append The appendix to be placed after format name
     * */
    public ExportFormatCommand(ExportFormat format, String append) {
        super(format.formatName() + append);
        setFormat(format);
    }

    // Methods


    /**
     * Returns the FormatId.
     * @ensure result != null
     * @return FormatId the formatId
     */
    public ExportFormat format() {
        ExportFormat result = null;
        result = _format;
        assert (result != null) : "Failure in GuiPlugin.FormatCommand: result == null";
        return result;
    }

    /**
     * Sets _formatId to formatId.
     * @ensure formatId() != null
     * @param format the value to be set
     */
    private void setFormat(ExportFormat format) {
        _format = format;
        assert (format() != null) : "Failure in GuiPlugin.FormatCommand: formatId() == null";
    }

    @Override
    public abstract boolean isExecutable();
}