/*
 * @(#)HandleTracker.java 5.1
 *
 */
package CH.ifa.draw.standard;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Handle;


/**
 * HandleTracker implements interactions with the handles
 * of a Figure.
 *
 * @see SelectionTool
 */
public class HandleTracker extends AbstractTool {
    private Handle fAnchorHandle;

    public HandleTracker(DrawingEditor editor, Handle anchorHandle) {
        super(editor);
        fAnchorHandle = anchorHandle;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        fAnchorHandle.invokeStart(e, x, y, view());
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        fAnchorHandle.invokeStep(e, x, y, fAnchorX, fAnchorY, view());
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        if (SwingUtilities.isRightMouseButton(e)) {
            fAnchorHandle.abort(view());
        } else {
            fAnchorHandle.invokeEnd(e, x, y, fAnchorX, fAnchorY, view());
        }
    }
}