package CH.ifa.draw.standard;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.util.ColorMap;


public class InitialAttributesMenu extends JPanel {

    AttributeFigure fprototype;
    Color originalFillColor;
    Color originalPenColor;
    Color originalTextColor;
    Integer originalArrow;
    String originalLineStyle;
    Integer originalLineWidth;

    public InitialAttributesMenu(AttributeFigure prototype) {
        fprototype = prototype;
        originalFillColor = prototype.getFillColor();
        originalPenColor = prototype.getFrameColor();
        originalTextColor = (Color) prototype.getAttribute("TextColor");
        originalArrow = (Integer) prototype.getAttribute("ArrowMode");
        originalLineStyle = (String) prototype.getAttribute("LineStyle");
        originalLineWidth = (Integer) prototype.getAttribute(AttributeFigure.LINE_WIDTH_KEY);

        this.add(createMenu());

        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fprototype.setAttribute("FillColor", originalFillColor);
                fprototype.setAttribute("FrameColor", originalPenColor);
                fprototype.setAttribute("TextColor", originalTextColor);
                fprototype.setAttribute("ArrowMode", originalArrow);
                fprototype.setAttribute("LineStyle", originalLineStyle);
                fprototype.setAttribute(AttributeFigure.LINE_WIDTH_KEY, originalLineWidth);
            }
        });
        this.add(resetButton);
    }

    public JPanel createMenu() {
        JPanel options = new JPanel();
        options.setLayout(new GridLayout(3, 2));

        options.add(createColorMenu("Fill Color", "FillColor"));
        options.add(createColorMenu("Pen Color", "FrameColor"));
        options.add(createColorMenu("Text Color", "TextColor"));
        options.add(createArrowMenu());
        options.add(createLineStyleMenu());
        options.add(createLineWidthMenu());

        return options;
    }

    private JPanel createLineWidthMenu() {
        JPanel linewidthpanel = new JPanel();
        linewidthpanel.add(new JLabel("Line Width"));
        Integer[] linewidthlist = new Integer[10];
        for (int i = 0; i < 10; i++) {
            linewidthlist[i] = i + 1;
        }

        final JComboBox comboBox = new JComboBox(linewidthlist);
        comboBox.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                int width = (int) comboBox.getSelectedItem();
                fprototype.setAttribute(AttributeFigure.LINE_WIDTH_KEY, width);

            }
        });
        linewidthpanel.add(comboBox);

        return linewidthpanel;
    }

    private JPanel createLineStyleMenu() {
        JPanel linestylepanel = new JPanel();
        linestylepanel.add(new JLabel("Line Style"));
        String[] linestylelist =
            { "Normal", "Dotted", "Dashed", "Medium Dashed", "Long Dashed", "Dash-Dotted" };

        final JComboBox comboBox = new JComboBox(linestylelist);
        comboBox.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                String linestyle = (String) comboBox.getSelectedItem();
                switch (linestyle) {
                    case "Normal":
                        fprototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_NORMAL);
                        break;
                    case "Dotted":
                        fprototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DOTTED);
                        break;
                    case "Dashed":
                        fprototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DASHED);
                        break;
                    case "Medium Dashed":
                        fprototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_MEDIUM_DASHED);
                        break;
                    case "Long Dashed":
                        fprototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_LONG_DASHED);
                        break;
                    case "Dash-Dotted":
                        fprototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DASH_DOTTED);
                        break;
                }
            }
        });
        linestylepanel.add(comboBox);

        return linestylepanel;
    }

    private JPanel createColorMenu(String name, final String attribute) {
        JPanel colorpanel = new JPanel();
        colorpanel.add(new JLabel(name));

        int size = ColorMap.size();
        ColorComboBoxItem[] colorlist = new ColorComboBoxItem[size];


        for (int i = 0; i < size; i++) {
            colorlist[i] = new ColorComboBoxItem(ColorMap.color(i), ColorMap.name(i));
        }

        final JComboBox comboBox = new JComboBox(colorlist);
        comboBox.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                ColorComboBoxItem comboitem = (ColorComboBoxItem) comboBox.getSelectedItem();
                fprototype.setAttribute(attribute, comboitem.getColor());
            }
        });
        colorpanel.add(comboBox);

        return colorpanel;
    }

    private JPanel createArrowMenu() {
        JPanel arrowpanel = new JPanel();
        arrowpanel.add(new JLabel("Arrow Style"));
        String[] arrowlist = { "No Arrow", "Start", "End", "Start/End" };

        final JComboBox comboBox = new JComboBox(arrowlist);
        comboBox.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                String arrow = (String) comboBox.getSelectedItem();
                switch (arrow) {
                    case "No Arrow":
                        fprototype.setAttribute(
                            "ArrowMode", Integer.valueOf(PolyLineFigure.ARROW_TIP_NONE));
                        break;
                    case "Start":
                        fprototype.setAttribute(
                            "ArrowMode", Integer.valueOf(PolyLineFigure.ARROW_TIP_START));
                        break;
                    case "End":
                        fprototype.setAttribute(
                            "ArrowMode", Integer.valueOf(PolyLineFigure.ARROW_TIP_END));
                        break;
                    case "Start/End":
                        fprototype.setAttribute(
                            "ArrowMode", Integer.valueOf(PolyLineFigure.ARROW_TIP_BOTH));
                        break;
                }
            }
        });
        arrowpanel.add(comboBox);

        return arrowpanel;
    }


    private class ColorComboBoxItem {

        Color fcolor;
        String fname;

        public ColorComboBoxItem(Color color, String name) {
            fcolor = color;
            fname = name;
        }

        @Override
        public String toString() {
            return fname;
        }

        public Color getColor() {
            return fcolor;
        }
    }
}
