/*
 * @(#)DrawingView.java 5.1
 *
 */
package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.NullGraphics;


// A class that provides a drawing view that does nothing.
// Useful to erase fields that must not be null.
public class NullDrawingView implements DrawingView, ImageObserver, DrawingChangeListener {
    private static Dimension nullDimension = new Dimension(0, 0);
    private static Point nullPoint = new Point(0, 0);
    public static NullDrawingView INSTANCE = new NullDrawingView();

    private NullDrawingView() {}

    @Override
    public void setEditor(DrawingEditor editor) {}

    @Override
    public Tool tool() {
        return NullTool.INSTANCE;
    }

    @Override
    public Drawing drawing() {
        return NullDrawing.INSTANCE;
    }

    @Override
    public void setDrawing(Drawing d) {}

    @Override
    public DrawingEditor editor() {
        return NullDrawingEditor.INSTANCE;
    }

    @Override
    public Figure add(Figure figure) {
        return figure;
    }

    @Override
    public Figure remove(Figure figure) {
        return figure;
    }

    @Override
    public void addAll(Vector<Figure> figures) {}

    @Override
    public void removeAll(Vector<Figure> figures) {}

    @Override
    public Dimension getSize() {
        return nullDimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return nullDimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return nullDimension;
    }

    @Override
    public void setDisplayUpdate(Painter updateStrategy) {}

    @Override
    public Vector<Figure> inZOrder(Vector<Figure> figures) {
        return (new Vector<Figure>(figures));
    }

    @Override
    public Vector<Figure> selection() {
        return new Vector<Figure>();
    }

    @Override
    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(new Vector<Figure>());
    }

    @Override
    public Vector<Figure> selectionZOrdered() {
        return new Vector<Figure>();
    }

    @Override
    public int selectionCount() {
        return 0;
    }

    @Override
    public void addToSelection(Figure figure) {}

    @Override
    public void addToSelectionAll(Vector<Figure> figures) {}

    @Override
    public void addToSelectionAll(FigureEnumeration figures) {}

    @Override
    public void removeFromSelection(Figure figure) {}

    @Override
    public void removeFromSelectionAll(Vector<Figure> figures) {}

    @Override
    public void removeFromSelectionAll(FigureEnumeration figures) {}

    @Override
    public void toggleSelection(Figure figure) {}

    @Override
    public void toggleSelectionAll(Vector<Figure> figures) {}

    @Override
    public void toggleSelectionAll(FigureEnumeration figures) {}

    @Override
    public void clearSelection() {}

    @Override
    public void selectionInvalidateHandles() {}

    @Override
    public FigureSelection getFigureSelection() {
        return new FigureSelection(new Vector<Figure>());
    }

    @Override
    public Handle findHandle(int x, int y) {
        return null;
    }

    @Override
    public Point lastClick() {
        return nullPoint;
    }

    @Override
    public Point getCurrentMousePosition() {
        return null;
    }

    @Override
    public void setConstrainer(PointConstrainer p) {}

    @Override
    public PointConstrainer getConstrainer() {
        return null;
    }

    @Override
    public void checkDamage() {}

    @Override
    public void repairDamage() {}

    @Override
    public void paint(Graphics g) {}

    @Override
    public Image createImage(int width, int height) {
        // Supposedly this method is only called by the update
        // strategy. But I do not call the update strategy and
        // nobody else is supposed to call it. Therefore it
        // should be safe to return a null. 
        return null;
    }

    @Override
    public Graphics getGraphics() {
        return new NullGraphics();
    }

    @Override
    public Color getBackground() {
        return Color.white;
    }

    @Override
    public void setBackground(Color c) {}

    @Override
    public void drawAll(Graphics g) {}

    public void invalidateHandles() {}

    @Override
    public void drawHandles(Graphics g) {}

    @Override
    public void drawDrawing(Graphics g) {}

    @Override
    public void drawBackground(Graphics g) {}

    @Override
    public void setCursor(Cursor c) {}

    @Override
    public void freezeView() {}

    @Override
    public void unfreezeView() {}

    @Override
    public void moveSelection(int dx, int dy) {}

    @Override
    public boolean imageUpdate(Image img, int inf, int x, int y, int w, int h) {
        return false;
    }

    @Override
    public void drawingInvalidated(DrawingChangeEvent event) {}

    @Override
    public void drawingRequestUpdate(DrawingChangeEvent event) {}

    @Override
    public void showElement(Figure fig) {}

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex)
        throws PrinterException
    {
        return Printable.NO_SUCH_PAGE;
    }

    @Override
    public AffineTransform getAffineTransform() {
        return null;
    }
}