package CH.ifa.draw.standard;

import java.awt.*;
import java.util.LinkedList;
import java.util.List;

import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingViewDecoration;


public class StandardDrawingViewFactory
    implements MultipleCDockableFactory<StandardDrawingViewContainer, DrawingLayoutWrapper>
{

    protected StandardDrawingEditor fEditor;
    private List<DrawingViewDecoration> decorations = new LinkedList<DrawingViewDecoration>();

    public static org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(StandardDrawingViewFactory.class);

    public StandardDrawingViewFactory(StandardDrawingEditor editor) {
        fEditor = editor;
        AttributeMenuDecoration attributeMenuDecoration = new AttributeMenuDecoration();
        editor.registerSelectionChangeListener(attributeMenuDecoration);
        this.addDecoration(attributeMenuDecoration);
    }

    @Override
    public DrawingLayoutWrapper write(StandardDrawingViewContainer standardDrawingViewContainer) {
        return new DrawingLayoutWrapper(standardDrawingViewContainer.getView().drawing());
    }

    @Override
    public StandardDrawingViewContainer read(DrawingLayoutWrapper layout) {

        logger.debug("Creating a new view container for a drawing.");

        Drawing drawing = layout.drawing();
        StandardDrawingView view = createViewFromDrawing(drawing);
        view.setDrawing(drawing);
        StandardDrawingViewContainer container = new StandardDrawingViewContainer(this, view);
        container.setTitleText(drawing.getName());

        logger.debug("Adding additional decorations to view container.");
        addDecorations(container);

        return container;
    }

    protected StandardDrawingView createViewFromDrawing(Drawing drawing) {
        Dimension d = drawing.defaultSize();
        StandardDrawingView view = new StandardDrawingView(fEditor, d.width, d.height);
        return view;
    }

    @Override
    public boolean match(
        StandardDrawingViewContainer standardDrawingViewContainer, DrawingLayoutWrapper layout)
    {
        Drawing drawing = layout.drawing();
        return standardDrawingViewContainer.getView().drawing().equals(drawing);
    }

    @Override
    public DrawingLayoutWrapper create() {
        return new DrawingLayoutWrapper(new StandardDrawing());
    }

    /**
     * Register a new decoration with which every new {@link CH.ifa.draw.application.DrawingViewContainer} provided by this factory will be decorated.
     *
     * @param decoration
     */
    public void addDecoration(DrawingViewDecoration decoration) {
        decorations.add(decoration);
    }

    protected void addDecorations(StandardDrawingViewContainer container) {

        LinkedList<CAction> actions;

        for (DrawingViewDecoration decoration : decorations) {
            actions = decoration.getDecorations();

            for (CAction action : actions) {
                container.addAction(action);
            }
            container.addSeparator();
        }
    }
}
