/*
 * @(#)Filler.java 5.1
 *
 */
package CH.ifa.draw.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;


/**
 * A component that can be used to reserve white space in a layout.
 */
public class Filler extends Canvas {
    /** The width of the filler */
    private int fWidth;

    /** The height of the filler */
    private int fHeight;

    /** The background color of the filler */
    private Color fBackground;

    /**
     * Constructs a new Filler, which is a blank rectangle, with no background color
     * and custom hight and width.
     *
     * @param width the width of the filler
     * @param height the height of the filler
     */
    public Filler(int width, int height) {
        this(width, height, null);
    }

    /**
     * Constructs a new Filler, which is a blank rectangle, with custom
     * background color, width and height.
     *
     * @param width the width of the filler
     * @param height the height of the filler
     * @param background the background color
     */
    public Filler(int width, int height, Color background) {
        fWidth = width;
        fHeight = height;
        fBackground = background;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(fWidth, fHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return getMinimumSize();
    }

    @Override
    public Color getBackground() {
        if (fBackground != null) {
            return fBackground;
        }
        return super.getBackground();
    }
}