/*
 * @(#)PaletteIcon.java 5.1
 *
 */
package CH.ifa.draw.util;

import java.awt.Dimension;
import java.awt.Image;


/**
 * A three state icon that can be used in palettes.
 * <br>
 * {@link CH.ifa.draw.standard.ToolButton}
 */
public class PaletteIcon {
    Image fNormal;
    Image fPressed;
    Image fSelected;
    Dimension fSize;

    /**
     * Constructs an icon to be used in e. g. palettes. Three images need to be given in order to
     * represent different states of the icon.
     *
     * @param size the size of the icon
     * @param normal Image for the icon in its default state
     * @param pressed Image for the icon in its pressed state
     * @param selected Image for the icon in its selected state
     */
    public PaletteIcon(Dimension size, Image normal, Image pressed, Image selected) {
        fSize = size;
        fNormal = normal;
        fPressed = pressed;
        fSelected = selected;
    }

    /**
     * Gets the image of the icon in its normal state.
     *
     * @return the image of the normal state
     */
    public Image normal() {
        return fNormal;
    }

    /**
     * Gets the image of the icon in its pressed state.
     *
     * @return the image of the pressed state
     */
    public Image pressed() {
        return fPressed;
    }

    /**
     * Gets the image of the icon in its selected state.
     *
     * @return the image of the selected state
     */
    public Image selected() {
        return fSelected;
    }

    /**
     * Gets the palette icon width.
     *
     * @return the width of the palette icon
     */
    public int getWidth() {
        return fSize.width;
    }

    /**
     * Gets the palette icon height.
     *
     * @return the height of the palette icon
     */
    public int getHeight() {
        return fSize.height;
    }
}