/*
 * @(#)PaletteListener.java 5.1
 *
 */
package CH.ifa.draw.util;

import CH.ifa.draw.standard.ToolButton;


/**
 * Interface for handling palette events.
 * <br>
 * {@link ToolButton}
 */
public interface PaletteListener {

    /**
     * The user selected a palette entry. The selected button is
     * passed as an argument.
     *
     * @param button the selected button.
     * @param doubleclick user double-clicked.
     */
    void paletteUserSelected(ToolButton button, boolean doubleclick);

    /**
     * The user moved the mouse over the palette entry.
     *
     * @param button the button the user selected.
     * @param inside is the user over a pallet.
     */
    void paletteUserOver(ToolButton button, boolean inside);
}