package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Test class for the class NoFileFilter.
 */
public class NoFileFilterTest {

    /**
     * Tests the constructor of the NoFileFilter class.
     */
    @Test
    public void testNoFileFilter() {

        //when
        NoFileFilter testFilter = new NoFileFilter();

        //then
        assertThat(testFilter).returns("No Specific File Type", NoFileFilter::getDescription)
            .returns("", NoFileFilter::getExtension);
    }

    /**
     * Tests the accept method.
     */
    @Test
    public void testAccept() {
        //given
        NoFileFilter testFilter = new NoFileFilter();
        File testFile = new File("Dummy.txt");

        // when/then
        assertThat(testFilter.accept(testFile)).isTrue();
    }

}
