package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class PNGFileFilterTest {
    private PNGFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new PNGFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .png extension gets accepted, as it should.
     */
    @Test
    public void testAcceptPNG() {
        //given
        File file = new File("painting.png");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-PNG-File is rejected correctly.
     */
    @Test
    public void testAcceptNotPNG() {
        //given
        File file = new File("test.pdf");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created PNG-Filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Portable Network Graphics File");
    }
}