package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class SerializedFileFilterTest {
    private SerializedFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new SerializedFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .ser extension gets accepted, as it should.
     */
    @Test
    public void testAcceptSER() {
        //given
        File file = new File("test.ser");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-SER-File is rejected correctly.
     */
    @Test
    public void testAcceptNotSER() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created SER-Filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Serialized (Renew1.0) Drawing");
    }

}