package CH.ifa.draw.standard;

import java.awt.event.MouseEvent;
import java.util.Vector;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

public class SelectionToolTest {
    private SelectionTool selectionTool;
    private DrawingEditor editor;
    private Drawing drawing;
    private StandardDrawingView view;
    private Figure figure;

    @BeforeEach
    public void setup() {
        editor = mock(DrawingEditor.class);
        drawing = mock(Drawing.class);
        view = mock(StandardDrawingView.class);
        figure = mock(Figure.class);
        selectionTool = new SelectionTool(editor);
        when(editor.view()).thenReturn(view);
        when(editor.drawing()).thenReturn(drawing);
        when(drawing.findFigure(10, 10)).thenReturn(figure);
        when(view.selection()).thenReturn(new Vector<>());
    }

    @Test
    public void testSimpleLeftClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON1_DOWN_MASK);

        selectionTool.mouseDown(event, 10, 10);

        verify(view).addToSelection(figure);
    }

    @Test
    public void testSimpleRightClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON2_DOWN_MASK);

        selectionTool.mouseDown(event, 10, 10);

        verify(figure).inspect(any(), eq(true));
    }

    @Test
    public void testSimpleMiddleClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON3_DOWN_MASK);

        selectionTool.mouseDown(event, 10, 10);

        verify(figure).inspect(any(), eq(true));
    }
}
