/*
 * Created on Jun 5, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

package de.renew.fa.commands;

import java.util.Objects;
import java.util.Vector;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FigureDecoration;
import de.renew.gui.GuiPlugin;


/**
 * The command that is executed to change the decoration of a state.
 * Options for decoration are
 * <ul>
 *         <li>start</li>
 *         <li>end</li>
 *         <li>start/end</li>
 *         <li>none</li>
 * </ul>
 *
 * @author jo
 */
public class ChangeDecorationCommand extends Command {

    private final FigureDecoration _deco;

    /**
     * Constructs a command with name and a decoration.
     *
     * @param name the name of the command in the ui
     * @param deco the type of decoration to switch to
     */
    public ChangeDecorationCommand(String name, FigureDecoration deco) {
        super(name);
        _deco = deco;
        // TODO Auto-generated constructor stub
    }

    /**
     * Changes the decoration, but also checks,
     * if there is a start state already in case to change type to start state,
     * and tells the FADrawing to allow a start state again in case a start state
     * is changed to another type.
     * <p>
     * {@link CH.ifa.draw.util.Command#execute()}
     */
    @Override
    public void execute() {
        DrawingView view = Objects.requireNonNull(GuiPlugin.getCurrent()).getDrawingEditor().view();
        Vector<Figure> selection = view.selection();
        for (Figure figure : selection) {
            if (figure instanceof FAStateFigure fafigure) {

                // FigureDecoration fd = fafigure.getDecoration();
                // if (_deco.equals(fd) ){
                // fafigure.setDecoration(null);
                // }
                // else{
                fafigure.setDecoration(_deco);
                fafigure.changed();

                // }
                // fafigure.invalidate();
            }
        }
        view.checkDamage();
    }
}