package de.renew.fa.commands;

import CH.ifa.draw.util.Command;
import de.renew.fa.FAPlugin;
import de.renew.plugin.IPlugin;


/**
 * The command that is executed for showing the net components.
 *
 * @author Lawrence Cabac
 */
public class ShowPaletteCommand extends Command {
    private final IPlugin _plugin;

    /**
     * Creates a command to show the net components.
     *
     * @param plugin a reference to the FA plugin to later toggle the net components visibility
     */
    public ShowPaletteCommand(IPlugin plugin) {
        super("FA Drawing Tool");

        _plugin = plugin;
    }

    /**
     * Shows the Net Components Tools Palette.
     * {@link Command#execute()}
     */
    @Override
    public void execute() {
        //        logger.debug ("showPaletteCommand executed.");
        FAPlugin pcp = (FAPlugin) _plugin;
        pcp.create();
    }
}