package de.renew.fa.commands;

import CH.ifa.draw.util.Command;
import de.renew.fa.gui.FASimulationSettingsInterface;


/**
 * The command that is executed for showing the settings menu.
 */
public class ShowSettingsCommand extends Command {

    private final FASimulationSettingsInterface _settingsMenu;

    /**
     * Creates the settings menu.
     *
     * @param settingsMenu Instance of the settings GUI.
     */
    public ShowSettingsCommand(FASimulationSettingsInterface settingsMenu) {
        super("FA Simulation Settings");
        this._settingsMenu = settingsMenu;
    }

    /**
     * Shows the simulation settings menu.
     * {@link Command#execute()}
     */
    @Override
    public void execute() {
        _settingsMenu.showGui();
    }
}