/*
 * Created on May 22, 2006
 *
 */

package de.renew.fa.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.fa.FAPlugin;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;


/**
 * @author cabac
 *
 */
public class FADrawMode {
    public static final int STANDARD = 0;
    public static final int ALTERNTIVE = 1;
    private static FADrawMode _instance;
    private int _mode = ALTERNTIVE;

    private FADrawMode() {
        super();
        IPlugin plugin = getplugin();

        //System.out.println("=================="+plugin);
        if (plugin != null) {
            String mode = plugin.getProperties().getProperty("de.renew.fa.mode");
            if ("alternative".equals(mode)) {
                _mode = ALTERNTIVE;
            } else if ("standard".equals(mode)) {
                _mode = STANDARD;
            }
        }
    }

    /**
     * @return IPlugin
     */
    private IPlugin getplugin() {
        IPlugin plugin = null;
        try {
            plugin =
                PluginManager.getInstance().getPluginsProviding("de.renew.fa").iterator().next();
        } catch (Exception e) {
            // e.printStackTrace();
        }
        return plugin;
    }

    /**
     * @return FADrawMode
     */
    public static FADrawMode getInstance() {
        if (_instance == null) {
            _instance = new FADrawMode();
        }
        return _instance;
    }

    public int getMode() {
        return _mode;
    }

    public void setMode(int mode) {
        _mode = mode;
        IPlugin p = getplugin();
        if (p != null) {
            ((FAPlugin) p).switchPalette();
        }
        DrawingEditor editor = DrawPlugin.getCurrent().getDrawingEditor();
        FigureEnumeration en = editor.drawing().figures();
        while (en.hasMoreElements()) {
            Figure fig = en.nextFigure();
            fig.changed();
        }
        editor.view().checkDamage();
    }
}