/*
 * Created on Aug 1, 2005
 *
 */

package de.renew.fa.model;


/**
 * @author cabac
 *
 */
public class StateImpl implements State {
    private String _name;
    private boolean _endState;
    private boolean _startState;

    public StateImpl() {
        super();
        // TODO Auto-generated constructor stub
    }

    /**
     * @param token the identifier of the state to be created
     */
    public StateImpl(String token) {
        _name = token;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State state = (State) obj;
            return this.getName().equals(state.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return _name.hashCode();
    }


    /**
     * @return the name as string.
     */
    @Override
    public String getName() {
        return _name;
    }

    /**
     * @return Returns the endState.
     */
    @Override
    public boolean isEndState() {
        return _endState;
    }

    /**
     * @return Returns the startState.
     */
    @Override
    public boolean isStartState() {
        return _startState;
    }

    /**
     * @param endState
     *            The endState to set.
     */
    @Override
    public void setEndState(boolean endState) {
        this._endState = endState;
    }

    /**
     * @param startState
     *            The startState to set.
     */
    @Override
    public void setStartState(boolean startState) {
        this._startState = startState;
    }

    @Override
    public String toString() {
        return "" + _name;
    }
}