package de.renew.fa.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

import CH.ifa.draw.framework.Drawing;
import de.renew.fa.util.FAHelper;


/**
 * Defines the XFA format for a finite automata drawing (<code>FADrawing</code>).
 *
 * {@link de.renew.fa.util.FAHelper}
 * {@link de.renew.fa.service.FAFileParser}
 * @author jo
 *
 */
public class XFAFormat {
    /**
     * Check whether export is allowed using this format.
     * It might have been planned that export is not allowed for certain formats.
     * Instead, this is implemented via {@link CH.ifa.draw.DrawPlugin#getExportHolder()}
     *
     * @return true
     */
    //TODO: Check if this code is used
    public boolean canExport() {
        return true;
    }

    /**
     * Check whether import is allowed using this format.
     * It might have been planned that import is not allowed for certain formats.
     * Instead, this is implemented via {@link CH.ifa.draw.DrawPlugin#getImportHolder()}
     *
     * @return true
     */
    //TODO: Check if this code is used
    public boolean canImport() {
        return true;
    }

    /**
     * Parse a XFA and convert the parsed model into a {@link de.renew.fa.FADrawing}.
     *
     * @param stream the input stream
     * @param name the name of the model
     * @return a list of one drawing
     *        (To maintain compatibility with {@link de.renew.gui.XMLFormat}.)
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling
    public List<Drawing> parse(InputStream stream, String name) throws Exception {
        return Collections.singletonList(
            FAHelper.convertModelToDrawing(new FAFileParser().parseXFA(stream, name)));
    }

    /**
     * Writes a FADrawing to an output stream in XFA format.
     *
     * @param stream the output stream
     * @param drawing the Drawing
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling
    public void write(OutputStream stream, Drawing drawing) throws Exception {
        FAFileParser.writeToXFA(stream, drawing);
    }

    /**
     * Writes multiple FADrawing to an output stream in XFA format.
     *
     * @param stream the output stream
     * @param drawings the <code>FADrawing</code>
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling
    public void write(OutputStream stream, Drawing[] drawings) throws Exception {
        //TODO fix this; only one drawing is written to the output stream, yet
        write(stream, drawings[0]);
    }
}