package de.renew.formalism.fs;

import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Path;

import de.renew.expression.Function;
import de.renew.unify.Impossible;


public class FSAtFunction implements Function {
    Path _path;
    boolean _unpacking = true;

    public FSAtFunction(String feat) {
        _path = new Path(feat);
    }

    public FSAtFunction(Path path, boolean unpacking) {
        this._path = path;
        this._unpacking = unpacking;
    }

    @Override
    public Object function(Object param) throws Impossible {
        FeatureStructure fs;
        if (param instanceof FeatureStructure) {
            fs = (FeatureStructure) param;
        } else {
            fs = new FeatureStructure(JavaObject.getJavaType(param));
        }
        try {
            if (_unpacking) {
                return fs.unpackingAt(_path);
            } else {
                return fs.at(_path);
            }
        } catch (NoSuchFeatureException nsf) {
            throw new Impossible(nsf.getMessage());
        }
    }
}