package de.renew.formalism.fs;

import java.util.List;

import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowNet;


public class ShadowConcept extends ShadowInscribable {
    private String _namespace;
    private String _name;
    private String _approp;
    private String _conceptDocumentation;
    private List<String> _slotDocumentation;
    private String _conceptAnnotation;
    private List<String> _slotAnnotation;
    private String _stereotype;

    public ShadowConcept(
        ShadowNet net, String name, String approp, String conceptDocumentation,
        List<String> slotDocumentation, String conceptAnnotation, List<String> slotAnnotation,
        String stereotype)
    {
        super(net);
        int end = name.indexOf("::");
        if (end == -1) {
            _namespace = net.getName();
            this._name = name;
        } else {
            _namespace = name.substring(0, end);
            this._name = name.substring(end + 2);
        }
        this._approp = approp;
        this._conceptDocumentation = conceptDocumentation;
        this._slotDocumentation = slotDocumentation;
        this._conceptAnnotation = conceptAnnotation;
        this._slotAnnotation = slotAnnotation;
        this._stereotype = stereotype;
    }

    public String getName() {
        return _name;
    }

    public String getNamespace() {
        return _namespace;
    }

    public String getFullName() {
        return _namespace + "::" + _name;
    }

    public void setApprop(String approp) {
        this._approp = approp;
    }

    public String getApprop() {
        return _approp;
    }

    @Override
    public void discard() {
        // is there anything else to do here?
    }

    public String getConceptDocumentation() {
        return _conceptDocumentation;
    }

    public List<String> getSlotDocumentation() {
        return _slotDocumentation;
    }

    public String getConceptAnnotation() {
        return _conceptAnnotation;
    }

    public List<String> getSlotAnnotation() {
        return _slotAnnotation;
    }

    public String getStereotype() {
        return _stereotype;
    }
}