package de.renew.formalism.fs;

import de.renew.shadow.ShadowNetElement;


public class ShadowIsa extends ShadowNetElement {
    private ShadowConcept _from;
    private ShadowConcept _to;
    private boolean _isDisjunctive;

    public ShadowIsa(ShadowConcept from, ShadowConcept to) {
        this(from, to, false);
    }

    public ShadowIsa(ShadowConcept from, ShadowConcept to, boolean isDisjunctive) {
        super(from.getNet());
        this._from = from;
        this._to = to;
        this._isDisjunctive = isDisjunctive;
        from.add(this);
    }

    public ShadowConcept getSource() {
        return _from;
    }

    public ShadowConcept getTarget() {
        return _to;
    }

    public boolean isDisjunctive() {
        return _isDisjunctive;
    }

    /*
      public void discard() {
        super.discard();
        // is there anything else to do here?
      }
    */


    /**
     * Deserialization method, behaves like default readObject
     * method, additionally re-registers the Isa at its
     * <code>from</code> concept.
     **/
    private void readObject(java.io.ObjectInputStream in)
        throws java.io.IOException, ClassNotFoundException
    {
        in.defaultReadObject();
        _from.add(this);
    }
}