package de.renew.gui.fs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import de.uni_hamburg.fs.Node;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.ClickHandle;


/**
 * The class to handle tags.
 */
public class TagHandle extends ClickHandle {
    Drawable _highlight;
    Node _node;
    boolean _selected;

    /**
     * Constructor for the tag handle.
     *
     * @param owner owner of the handle
     * @param box box of the handle
     * @param highlight highlight of the handle
     * @param node  node of the handle
     * @param selected is handle selected
     */
    public TagHandle(
        FSFigure owner, Rectangle box, Drawable highlight, Node node, boolean selected)
    {
        super(owner, ColorMap.NONE, Color.red, box);
        setHighlight(highlight);
        this._node = node;
        this._selected = selected;
    }

    /**
     * Set the highlight if the handle.
     *
     * @param highlight {@link Drawable} to be the highlight
     */
    public void setHighlight(Drawable highlight) {
        this._highlight = highlight;
    }

    /**
     * Draws this handle.
     */
    @Override
    public void draw(Graphics g) {
        if (_selected) {
            Rectangle fsbox = owner().displayBox();
            g.translate(fsbox.x, fsbox.y);
            g.setColor(Color.red);
            _highlight.draw(g);
            g.translate(-fsbox.x, -fsbox.y);
        }
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        ((FSFigure) owner()).setSelectedTag(_node);
    }
}