package de.uni_hamburg.fs;

/**
 * Exception thrown when attempting to access a feature that does not exist in a given type.
 * This is a runtime exception indicating an invalid feature access attempt.
 */
public class NoSuchFeatureException extends RuntimeException {
    /**
     * Constructs a new NoSuchFeatureException with the specified feature and type.
     *
     * @param feature the name of the feature that was not found
     * @param type the type in which the feature was searched for
     */
    public NoSuchFeatureException(Name feature, Type type) {
        super("Feature " + feature + " not allowed in type " + type + ".");
    }
}