package de.uni_hamburg.fs;

/**
 * Exception thrown when a feature structure cannot be instantiated.
 * This can occur when attempting to create an instance of a feature structure
 * that does not meet the required conditions for instantiation.
 */
public class NotInstantiableException extends Exception {
    /**
     * Constructs a {@code NotInstantiableException} with a detailed message
     * indicating that the specified feature structure is not instantiable.
     *
     * @param fs the feature structure that cannot be instantiated
     */
    public NotInstantiableException(FeatureStructure fs) {
        super("Feature Structure  is not instantiable:" + fs);
    }

    /**
     * Constructs a {@code NotInstantiableException} with the specified detail message.
     *
     * @param msg the detail message explaining why the exception was thrown
     */
    public NotInstantiableException(String msg) {
        super(msg);
    }
}