package de.uni_hamburg.fs;

/**
 * Exception thrown when type-related errors occur during feature structure operations.
 * This exception specifically handles errors related to concepts and their features.
 */
public class TypeException extends UnificationFailure {
    /**
     * The concept implementation where the type exception occurred.
     */
    public final ConceptImpl _concept;
    /**
     * The name of the feature where the type exception occurred.
     */
    public final Name _featureName;

    /**
     * Constructs a new TypeException with no concept and feature information.
     */
    public TypeException() {
        this(null, null, null);
    }

    /**
     * Constructs a new TypeException with the specified cause.
     *
     * @param cause the cause of this exception
     */
    public TypeException(Throwable cause) {
        this(null, null, cause);
    }

    /**
     * Constructs a new TypeException with the specified concept.
     *
     * @param concept the concept where the exception occurred
     */
    public TypeException(ConceptImpl concept) {
        this(concept, null, null);
    }

    /**
     * Constructs a new TypeException with the specified concept and feature name.
     *
     * @param concept the concept where the exception occurred
     * @param featureName the name of the feature where the exception occurred
     */
    public TypeException(ConceptImpl concept, Name featureName) {
        this(concept, featureName, null);
    }

    /**
     * Constructs a new TypeException with the specified concept, feature name, and cause.
     *
     * @param concept the concept where the exception occurred
     * @param featureName the name of the feature where the exception occurred
     * @param cause the cause of this exception
     */
    public TypeException(ConceptImpl concept, Name featureName, Throwable cause) {
        super(
            (concept == null) ? null
                : (concept + ((featureName == null) ? "" : ("@" + featureName))),
            cause);
        this._concept = concept;
        this._featureName = featureName;
    }
}