package de.renew.formalism.function;

import de.renew.util.Types;

/**
 * A function that invokes a method on an object based on its name.
 */
public class DynamicMethodFunction extends AbstractMethodFunction {
    /**
     * The name of the method to be invoked on the object.
     */
    private final String _method;

    /**
     * Creates an instance of this class describing a class function by its name that is supposed to be executed using this class.
     *
     * @param method the name of the function
     */
    public DynamicMethodFunction(String method) {
        this._method = method;
    }

    @Override
    public Object doFunction(Object obj, Object[] paramArr) throws Exception {
        return Executor.executeMethod(obj.getClass(), obj, _method, paramArr);
    }

    @Override
    public String toString() {
        return "DynamicMethodFunc: " + Executor.renderMethodSignature(Types.UNTYPED, _method, null);
    }
}