package de.renew.formalism.java;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadow.SyntaxException;

/**
 * An interface for classes that compile Arcs.
 *
 **/
public interface ArcFactory {
    /**
     * Checks if an Arc is Empty
     * @throws SyntaxException if syntax error occurs in compilation process
     */
    public void emptyArcCheck() throws SyntaxException;

    /**
     * Get-method for allowsTime
     * @return boolean if Arc allows Time (field variable for SimpleArc, true for outArc, false for inArc)
     */
    public boolean allowsTime();

    /**
     * Compiles an Arc
     * @param place the Place of the Arc
     * @param transition the Transition
     * @param trace Trace-Field of the Arc
     * @param placeType The type of the Place
     * @param inscription the Inscription of the arc
     * @throws SyntaxException if Syntax Error occurs in compilation process
     */
    public void compileArc(
        Place place, Transition transition, boolean trace, Class<?> placeType,
        ArcInscription inscription) throws SyntaxException;
}