package de.renew.formalism.java;


/**
 * This class extends the generated class {@link ParseException} to store
 * additional problem specific information.
 *
 * @author 6hauster
 *
 */
public class ExtendedParseException extends ParseException {

    /**
     * Arbitrary problem specific information.
     */
    private Object _o;

    /**
     * Creates an ExtendedParseException with an error message and extra information about the problem.
     *
     * @param message the error message
     * @param o arbitrary problem specific information
     */
    public ExtendedParseException(String message, Object o) {
        super(message);
        this._o = o;
    }

    /**
     * Returns the problem specific information.
     *
     * @return the arbitrary problem specific information
     */
    public Object getProblemSpecificInformation() {
        return this._o;
    }
}