package de.renew.formalism.java;

import java.util.Collection;

import de.renew.net.Transition;
import de.renew.shadow.ShadowLookup;

/**
 * Interface for parsing different kinds of inscriptions.
 */
public interface InscriptionParser {

    /**
     * Sets the declaration node for the parser.
     *
     * @param decl the declaration node
     */
    void setDeclarationNode(ParsedDeclarationNode decl);

    /**
     * Sets the lookup for shadowing.
     *
     * @param lookup the shadow lookup
     */
    void setLookup(ShadowLookup lookup);

    /**
     * Gets the declaration node.
     *
     * @return the parsed declaration node
     * @throws ParseException if parsing fails
     */
    @SuppressWarnings("checkstyle:MethodName")
    ParsedDeclarationNode DeclarationNode() throws ParseException;

    /**
     * Gets a collection of place inscriptions.
     *
     * @return a collection of place inscriptions
     * @throws ParseException if parsing fails
     */
    @SuppressWarnings("checkstyle:MethodName")
    Collection<Object> PlaceInscription() throws ParseException;

    /**
     * Gets a collection of arc inscriptions.
     *
     * @return a collection of arc inscriptions
     * @throws ParseException if parsing fails
     */
    @SuppressWarnings("checkstyle:MethodName")
    Collection<ArcInscription> ArcInscription() throws ParseException;

    /**
     * Gets a collection of transition inscriptions.
     *
     * @param create if true, the inscriptions will be created; if false, they will not
     * @param transition the transition object
     * @return a collection of transition inscriptions
     * @throws ParseException if parsing fails
     */
    @SuppressWarnings("checkstyle:MethodName")
    Collection<de.renew.net.TransitionInscription> TransitionInscription(
        boolean create, Transition transition) throws ParseException;

    /**
     * Gets a variable inscription.
     *
     * @return the parsed variable inscription
     * @throws ParseException if parsing fails
     */
    @SuppressWarnings("checkstyle:MethodName")
    TypedExpression VariableInscription() throws ParseException;

    /**
     * Tries to parse a channel inscription.
     *
     * @return the parsed channel inscription
     * @throws ParseException if parsing fails
     */
    ChannelInscription tryParseChannelInscription() throws ParseException;
}