package de.renew.formalism;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.junit.jupiter.api.Test;

import de.renew.formalism.java.FieldSuggestion;
import de.renew.net.arc.Arc;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

class FieldSuggestionTest {
    @Test
    public void testConstructor() throws NoSuchFieldException {
        //given
        Field testField;
        testField = de.renew.net.arc.Arc.class.getField("out");
        String attemptedName = "Test String";

        //when
        FieldSuggestion testFieldSuggestion = new FieldSuggestion(testField, attemptedName);

        //then
        assertNotNull(testFieldSuggestion);
        assertEquals(testFieldSuggestion.getAttemptedName(), attemptedName);
        assertEquals(testFieldSuggestion.getField(), testField);

    }

    @Test
    public void testSuggest() {
        //given
        List<FieldSuggestion> testList = new ArrayList<FieldSuggestion>();
        String[] arcSuggestions =
            { "both", "bothOT", "fastBoth", "fastTest", "in", "inhibitor", "out", "test" };
        for (int i = 0; i < Arc.class.getFields().length; i++) {
            FieldSuggestion fieldSuggestion =
                new FieldSuggestion(Arc.class.getFields()[i], Arc.class.getFields()[i].getName());
            for (int j = 0; j < arcSuggestions.length; j++) {
                if (fieldSuggestion.getName().equals(arcSuggestions[j])) {
                    testList.add(fieldSuggestion);
                }
            }
            //Sort the list by names
            Collections.sort(testList);
        }

        //when
        List<FieldSuggestion> outputList =
            FieldSuggestion.suggest(de.renew.net.arc.Arc.class, "Arc", 1);

        //then
        boolean areEqual = true;
        for (int i = 0; i < 8; i++) {
            if (!outputList.get(i).toString().equals(testList.get(i).toString())) {
                areEqual = false;
            }
        }
        assertTrue(areEqual);
    }

    @Test
    public void testToString() {
        //given
        Field testField;
        try {
            testField = Arc.class.getField("out");
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        String attemptedName = "Test String";
        FieldSuggestion testFieldSuggestion = new FieldSuggestion(testField, attemptedName);
        String testString = "<html>" + testField.getName() + " : " + testField.getType().toString()
            + " <font color=gray>- " + "Arc" + "</font></html>";

        //when
        String outputString = testFieldSuggestion.toString();

        //then
        assertEquals(outputString, testString);

    }
}