package de.renew.formalism.function;

import org.junit.jupiter.api.Test;

import de.renew.net.Net;
import de.renew.net.arc.Arc;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.mockito.Mockito.mock;

public class DynamicFieldWriteFunctionTest {

    @Test
    public void testFunctionException() throws Exception {
        //given
        de.renew.net.arc.Arc arcObject = mock(Arc.class);
        Object[] testValues = { arcObject, null };
        Tuple testTuple = new Tuple(testValues, null);
        DynamicFieldWriteFunction testDynamicFieldWriteFunction =
            new DynamicFieldWriteFunction("out");
        String exceptionMessage =
            "Exception occured during method call: java.lang.IllegalAccessException: "
                + "Can not set static final int field de.renew.net.arc.Arc.out to null value";
        //when
        Exception thrown = assertThrows(Impossible.class, () -> {
            testDynamicFieldWriteFunction.function(testTuple);
        });
        //then
        assertEquals(exceptionMessage, thrown.getMessage());
    }

    @Test
    public void testFunction() throws Impossible {
        //given
        Net testNetObject = mock(Net.class);
        Object[] testValues = { testNetObject, null };
        Tuple testTuple = new Tuple(testValues, null);
        DynamicFieldWriteFunction testDynamicFieldWriteFunction =
            new DynamicFieldWriteFunction("logger");
        //when
        Object output = testDynamicFieldWriteFunction.function(testTuple);
        //then
        assertEquals(Net.logger, output);
    }
}
