package de.renew.gui;

import java.awt.Dimension;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.DrawingLayoutWrapper;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewFactory;


public class CPNDrawingViewFactory extends StandardDrawingViewFactory {
    public CPNDrawingViewFactory(StandardDrawingEditor editor) {
        super(editor);
    }

    @Override
    protected StandardDrawingView createViewFromDrawing(Drawing drawing) {
        Dimension d = drawing.defaultSize();
        StandardDrawingView view;

        if (drawing instanceof CPNDrawing) {
            view = new CPNDrawingView(fEditor, d.width, d.height);
        } else if (drawing instanceof CPNInstanceDrawing) {
            view = new CPNInstanceDrawingView(fEditor, d.width, d.height);
        } else {
            view = new StandardDrawingView(fEditor, d.width, d.height);
        }

        return view;

    }

    @Override
    public DrawingLayoutWrapper create() {
        return new DrawingLayoutWrapper(new CPNDrawing());
    }
}