package de.renew.gui;

import CH.ifa.draw.util.Command;
import de.renew.gui.configure.ConfigureSimulationController;

/**
 * Opens a configuration dialog to control the simulation features
 * of the Renew simulator.
 * <p>
 * ConfigureSimulationCommand.java
 * Created: Mon Aug 11  2003
 *
 * @author Michael Duvigneau
 * @since Renew 2.0
 */
public class ConfigureSimulationCommand extends Command {
    private ConfigureSimulationController controller = null;

    public ConfigureSimulationCommand(String name) {
        super(name);
    }

    /**
     * This command is always executable.
     *
     * @return always <code>true</code>.
     * @see Command#isExecutable()
     **/
    @Override
    public boolean isExecutable() {
        // why is this used, if it should be always executable?
        return super.isExecutable();
    }

    /**
     * Displays a dialog to configure the simulation properties.
     **/
    @Override
    public void execute() {
        if (controller == null) {
            CPNApplication app = GuiPlugin.getCurrent().getGui();
            controller = new ConfigureSimulationController(app);
        }
        controller.showDialog();
    }
}