package de.renew.gui;

import java.util.EventObject;

import CH.ifa.draw.framework.Drawing;

/**
 * Drawing event passed to DrawingListeners.
 */
public class DrawingEvent extends EventObject {
    final Drawing _drawing;

    /**
     * Constructs an event for the given source Drawing.
     * @param source the object on which the Event initially occurred.
     * @param drawing the drawing that is created
     */
    public DrawingEvent(Object source, Drawing drawing) {
        super(source);
        _drawing = drawing;
    }

    /**
     * Gets the drawing of the source.
     * @return returns the drawing
     */
    public Drawing getDrawing() {
        return _drawing;
    }

    @Override
    public String toString() {
        return "DrawingEvent{source=" + source + ", _drawing=" + _drawing + '}';
    }
}
