package de.renew.gui;

import java.rmi.RemoteException;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import de.renew.remote.NetInstanceAccessor;


/**
 * A drawing that represents a net instance
 */
public interface InstanceDrawing extends Drawing, DrawingChangeListener {
    /**
     * Get the CPNDrawing this instance drawing is based on.
     */
    CPNDrawing getCpnDrawing();

    /**
     * A method to return an InstanceFigure from the instanceLookup that contains all
     * figures of the current InstanceDrawing.
     * @param fig the figure that is supposed to be returned
     * @return returns the figure specified in the method parameter
     * or returns null if there aren't any figures in the instanceLookup
     */
    InstanceFigure getInstanceFigure(Figure fig);

    /**
     * A method to return a InstanceFigure based on the id of its baseFigure.
     * @param id the id of the baseFigure in the CPNDrawing assigned to this InstanceDrawing
     * @return the InstanceFigure of the baseFigure
     */
    InstanceFigure getInstanceFigureOfFigureWithID(int id);

    /**
     * Connect the net instance with this InstanceDrawing and create and add
     * the instance figures.
     * @param netInstance the net instance to be displayed
     * @throws RemoteException If an RMI problem occurred.
     */
    void connect(NetInstanceAccessor netInstance) throws RemoteException;

    /**
     * Returns whether the instance drawing shows a local net instance.
     * Otherwise, the simulation of the shown net instance is run in a
     * different VM, usually on another computer.
     * @return Whether the shown net instance is local.
     */
    boolean isLocal();

    /**
     * Get the net instance accessor associated with this drawing.
     */
    Object getNetInstance();
}
