/*
 * ConfigureNetpathTab.java
 *
 * Created on 19. August 2003
 */
package de.renew.gui.configure;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;


/**
 *
 * @author Michael Duvigneau
 **/
class ConfigureNetpathTab extends JPanel {
    private JList<String> _pathList;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _editButton;
    private JButton _upButton;
    private JButton _downButton;

    /** Creates new form ConfigureNetpathTab */
    ConfigureNetpathTab() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     **/
    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        JScrollPane pathScrollPane = new JScrollPane();
        _pathList = new JList<>();

        setName("Net path");
        setLayout(new BorderLayout());

        buttonPanel.setLayout(new GridLayout(0, 1));

        _addButton = new JButton();
        _addButton.setText("Add...");
        _addButton
            .setToolTipText("Opens a dialog to add a new entry in front of  the selected entry.");
        buttonPanel.add(_addButton);

        _editButton = new JButton();
        _editButton.setText("Edit...");
        _editButton.setToolTipText("Opens a dialog for modification of the selected entry.");
        buttonPanel.add(_editButton);

        _upButton = new JButton();
        _upButton.setText("Move up");
        _upButton.setToolTipText("Moves the selected entry towards the beginning of the path list");
        buttonPanel.add(_upButton);

        _downButton = new JButton();
        _downButton.setText("Move down");
        _downButton.setToolTipText("Moves the selected entry towards the end of the path list.");
        buttonPanel.add(_downButton);

        _removeButton = new JButton();
        _removeButton.setText("Delete");
        _removeButton.setToolTipText("Deletes the selected entry from the path.");
        buttonPanel.add(_removeButton);

        add(buttonPanel, BorderLayout.EAST);

        _pathList.setToolTipText("Select path entries to move, modify or delete them.");
        pathScrollPane.setViewportView(_pathList);

        add(pathScrollPane, BorderLayout.CENTER);
    }

    /**
     * Registers an action listener to the "Add" button. The listener will be triggered
     * when the "Add" button is pressed, allowing custom behavior to be implemented.
     *
     * @param listener the ActionListener to register with the "Add" button.
     */
    void addAddEntryListener(ActionListener listener) {
        _addButton.addActionListener(listener);
    }

    /**
     * Registers an action listener to the "Remove" button. The listener will be triggered
     * when the "Remove" button is pressed, allowing custom behavior to be implemented.
     *
     * @param listener the ActionListener to register with the "Remove" button.
     */
    void addRemoveEntryListener(ActionListener listener) {
        _removeButton.addActionListener(listener);
    }

    /**
     * Registers an action listener to the "Edit" button. The listener will be triggered
     * when the "Edit" button is pressed, allowing custom behavior to be implemented.
     *
     * @param listener the ActionListener to register with the "Edit" button.
     */
    void addEditEntryListener(ActionListener listener) {
        _editButton.addActionListener(listener);
    }

    /**
     * Registers an action listener to the "Move Down" button. The listener will be triggered
     * when the "Move Down" button is pressed, allowing custom behavior to be implemented.
     *
     * @param listener the ActionListener to register with the "Down" button.
     */
    void addDownEntryListener(ActionListener listener) {
        _downButton.addActionListener(listener);
    }

    /**
     * Registers an action listener to the "Move Up" button.
     * The listener will be triggered when the "Move Up" button is pressed, allowing custom behavior to be implemented.
     *
     * @param listener the ActionListener to register with the "Up" button.
     */
    void addUpEntryListener(ActionListener listener) {
        _upButton.addActionListener(listener);
    }

    /**
     * Sets the model for the path list in the user interface.
     *
     * @param model the ListModel containing the string data to be displayed in the path list.
     */
    void setPathList(ListModel<String> model) {
        _pathList.setModel(model);
    }

    /**
     * Retrieves the model of the path list.
     *
     * @return the list model containing the string data displayed in the path list.
     */
    ListModel<String> getPathList() {
        return _pathList.getModel();
    }

    /**
     * Retrieves the selection model associated with the path list.
     *
     * @return the ListSelectionModel that manages the selection state of the path list.
     */
    ListSelectionModel getSelection() {
        return _pathList.getSelectionModel();
    }
}