package de.renew.gui.pnml.creator;

import java.awt.Color;

import org.w3c.dom.Element;

import de.renew.gui.pnml.converter.GraphicConverter;


public class GraphicCreator {
    private final PNMLCreator _pnmlCreator;
    private final Element _element;
    private Element line;

    /**
     * Creates a graphic
     * @param pnmlCreator a pnml creator
     */
    public GraphicCreator(PNMLCreator pnmlCreator) {
        _element = pnmlCreator.createElement("graphics");
        _pnmlCreator = pnmlCreator;
    }

    /**
     * Gets the element
     * @return the element
     */
    protected Element getElement() {
        return _element;
    }

    /**
     * Adds a position
     * @param x x coordinate of the position
     * @param y y coordinate of the position
     */
    public void addPosition(int x, int y) {
        Element position = _pnmlCreator.createElement("position");
        position.setAttribute("x", String.valueOf(x));
        position.setAttribute("y", String.valueOf(y));
        _element.appendChild(position);
    }

    /**
     * Adds a offset
     * @param x the x value of the offset
     * @param y the y value of the offset
     */
    public void addOffset(int x, int y) {
        Element offset = _pnmlCreator.createElement("offset");
        offset.setAttribute("x", String.valueOf(x));
        offset.setAttribute("y", String.valueOf(y));
        _element.appendChild(offset);
    }

    /**
     * Adds a dimension
     * @param x the x value of the dimension
     * @param y the y value of the dimension
     */
    public void addDimension(int x, int y) {
        Element dimension = _pnmlCreator.createElement("dimension");
        dimension.setAttribute("x", String.valueOf(x));
        dimension.setAttribute("y", String.valueOf(y));
        _element.appendChild(dimension);
    }

    /**
     * Fills the Element
     * @param c the color
     */
    public void addFill(Color c) {
        Element fill = _pnmlCreator.createElement("fill");
        fill.setAttribute(
            "color", "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        _element.appendChild(fill);
    }

    /**
     * Colors a line
     * @param c the color of the line
     */
    public void addLineColor(Color c) {
        getLineElement().setAttribute(
            "color", "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
    }

    /**
     * Styles a line
     * @param style the style of the line
     */
    public void addLineStyle(String style) {
        getLineElement()
            .setAttribute("style", GraphicConverter.instance().parseRenewLineStyle(style));
    }

    /**
     * Adds a line
     */
    public void addLine() {
        _element.appendChild(getLineElement());
    }

    private Element getLineElement() {
        if (line == null) {
            line = _pnmlCreator.createElement("line");
        }
        return line;
    }
}