package de.renew.gui.pnml.parser;

import org.w3c.dom.Element;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.gui.pnml.converter.NetConverter;


/**
 * @author volker
 * erstellt am Apr 30, 2004
 *
 */
public class VirtualPlaceParser extends NodeParser {
    private final Drawing _net;
    private int parentId;

    public VirtualPlaceParser(Element node, Drawing net, NetConverter converter) {
        super(node, converter);
        _net = net;
    }

    @Override
    public FigureWithID createObject() {
        FigureEnumeration figures = _net.figures();
        while (figures.hasMoreElements()) {
            Figure fig = figures.nextFigure();

            if (fig instanceof PlaceFigure place) {

                if (place.getID() == parentId) {
                    return new VirtualPlaceFigure(place);
                }
            }
        }

        return new VirtualPlaceFigure();
    }

    @Override
    protected void parseFigure() {
        parentId = Integer.parseInt(getElement().getAttribute("semanticPlaceFigure"));
    }
}