package de.renew.gui.tool;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.StandardDrawingView;
import de.renew.gui.GuiPlugin;

/**
 * Creates an AbstractZoomTool needed for the zoom buttons.
 */
public abstract class AbstractZoomTool extends AbstractTool {
    protected AbstractZoomTool(DrawingEditor editor) {
        super(editor);
    }

    protected StandardDrawingView getCurrentStandardDrawingView() {
        final GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin != null && guiPlugin.getDrawingEditor() != null) {
            final DrawingView view = guiPlugin.getDrawingEditor().view();
            if (view instanceof StandardDrawingView standardDrawingView) {
                return standardDrawingView;
            }
        }
        return null;
    }
}
